# Симуляция

Симуляции позволяют быстро тестировать код, не изменяя состояние фермы в действительности.
Ты можешь произвольно выбрать начальное состояние симуляции. Когда симуляция закончится, настоящая ферма останется в том же состоянии, в каком была до начала симуляции.

Для запуска симуляции используется функция `simulate()`.

Файл, с которого должно начаться выполнение:
`filename = "f1"`

Начать со всеми разблокированными и полностью улучшенными технологиями:
`sim_unlocks = Unlocks`

Начать с 10 000 моркови и 50 сена:
`sim_items = {Items.Carrot : 10000, Items.Hay : 50}`

Начать с глобальной переменной «a» со значением 13:
`sim_globals = {"a" : 13}`

Использовать заданное начальное значение для генерации случайных чисел:
`seed = 0`

Ускорить симуляцию в 64 раза:
`speedup = 64`

Запустить симуляцию:
`run_time = simulate(filename, sim_unlocks, sim_items, sim_globals, seed, speedup)`

Функция `simulate()` возвращает время в секундах, затраченное на симуляцию указанного стартового файла.

### Имя файла
Первый аргумент функции `simulate` — имя файла. Это имя отображается в верхней части окна с кодом. Симуляция запустит указанный файл так, как если бы в этом окне была нажата кнопка «Выполнить».

### Стартовые технологии
Все возможности языка программирования, включая циклы, операторы if, списки, словари, всегда остаются разблокированными.

Второй аргумент позволяет указать, с какими технологиями/улучшениями, помимо возможностей языка, должна начинаться симуляция. Его нужно представить в виде последовательности технологий. Симуляция начнется со всеми технологиями из последовательности, улучшенными до максимального уровня.

Если ты хочешь указать уровень улучшения, отличный от максимального, то можешь передать словарь, сопоставляющий технологии с уровнями. В этом случае отрицательные значения соответствуют максимальному уровню.

### Стартовые предметы
Третий аргумент позволяет передать словарь, сопоставляющий предметы с числами. Он указывает, с какими предметами начнется симуляция.

### Стартовые глобальные переменные
Поскольку симуляция запускает новое выполнение программы, ты не можешь получить доступ к переменным из программы, запускающей саму симуляцию.
Однако можно передать значения в симуляцию с помощью четвертого аргумента. Это словарь, сопоставляющий имена переменных, представленных в виде строк, со значениями. Указанные переменные добавляются в глобальную область видимости выполнения внутри симуляции.

Обрати внимание, что при этом копируются все значения, поэтому их изменение внутри симуляции не повлияет на исходные значения вне симуляции. Из симуляции невозможно вернуть никакие значения, кроме времени, которое заняло ее выполнение.

### Генерация случайных чисел
Пятый аргумент позволяет указать случайное начальное значение для генерации случайных чисел в симуляции. Это должно быть положительное целое число. Если указать отрицательное значение, будет использовано случайное число.

Начальное значение влияет на все: от времени роста растений до расположения лабиринтов и времени высыхания воды. Если ты запускаешь одну и ту же симуляцию несколько раз с одним и тем же начальным значением и одинаковыми начальными условиями, результат всегда должен быть одинаковым.

### Ускорение
Шестой аргумент — это начальное ускорение симуляции, которое позволяет быстрее тестировать код. Если игра не сможет поддерживать заданную скорость, она автоматически замедлится.

Ускорение не влияет на результат симуляции. Оно используется только для сокращения времени ожидания.